<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Travel url
 *
 * @Version 1.0.2
 * @author physcode
 */
class TravelPhysUrl {

	public static function init() {
		if ( wp_doing_ajax() ) {
			return;
		}

		if ( is_admin() ) {
			add_filter( 'post_row_actions', array( __CLASS__, 'change_link_tour_view_actions_phys' ), 11, 2 );
			add_filter( 'get_sample_permalink_html', array( __CLASS__, 'link_tour_backend' ), 11, 5 );
		} else {
			add_filter( 'post_type_link', array( __CLASS__, 'link_tour' ), 11, 2 );
			add_filter( 'rewrite_rules_array', array( __CLASS__, 'rewrite_rules' ), 11, 1 );
			add_action( 'init', array( __CLASS__, 'rewrite_slug_attribute_woo_by_phys' ) );

			// Redirect to slug of Tour if is slug of Product on single tour
			add_action( 'template_redirect', array( __CLASS__, 'check_is_tour_redirect_product_to_link_tour' ), 999 );

			// Menu tour frontend
			add_filter( 'wp_nav_menu_objects', array( __CLASS__, 'filter_nav_menu_item_tour_phys' ), 11, 1 );

			/*** For WPML ***/
			//add_filter( 'wpml_ls_html', 'fix_switcher_menu_for_tour', 20, 3 );
			//add_filter( 'wpml_get_translated_slug', 'wpml_get_translated_slug_for_tour', 20, 4 );
			add_filter( 'post_type_archive_link', array( __CLASS__, 'change_link_archive_product_when_is_tour' ), 999, 2 );
			add_filter( 'translate_object_id', array( __CLASS__, 'translate_object_id_of_page_show_tours' ), 20, 1 );

			/*** For Polylang ***/
			add_filter( 'pll_post_type_link', array( __CLASS__, 'filter_post_type_link_phys_polylang' ), 11, 3 );
			add_filter( 'pll_get_archive_url', array( __CLASS__, 'tour_url_polylang' ), 20, 2 );
		}
	}

	/**
	 * @deprecated 2.1.1
	 */
	/*public static function filter_post_type_link_tour_phys( $post_link, $post ) {
		$fixed_link = '';
		if ( 'product' == $post->post_type ) {
			$terms = get_the_terms( $post->ID, 'product_type' );

			if ( ! empty( $terms ) && $terms[0]->slug == 'tour_phys' ) {
				static $product_struct, $is_complex_struct, $cache = array();

				$cache_key = $post_link;
				if ( isset( $cache[ $cache_key ] ) ) {
					return $cache[ $cache_key ];
				}

				if ( null === $product_struct ) {
					if ( isset( $GLOBALS['wp_rewrite']->extra_permastructs['product'] ) ) {
						$product_struct_init = $GLOBALS['wp_rewrite']->extra_permastructs['product']['struct'];
						$mapper              = array(
							'`%product%`' => '{XPRODUCTX}',
							'`%\w+%`'     => '[^/]+',
						);
						$product_struct      = preg_replace( array_keys( $mapper ), $mapper, ( $product_struct_init && $product_struct_init[0] != '/' ? '/' : '' ) . $product_struct_init );
						$is_complex_struct   = strpos( $product_struct, '[^/]+' ) !== false;
					}
				}

				$what_replace   = str_replace( '{XPRODUCTX}', $post->post_name, $product_struct );
				$full_tour_slug = self::get_tour_base_slug( true ) . $post->post_name;
				if ( $is_complex_struct ) {
					$fixed_link = preg_replace( '`' . $what_replace . '`', $full_tour_slug, $post_link );
				} else {
					$fixed_link = str_replace( $what_replace, $full_tour_slug, $post_link );
				}
				$cache[ $cache_key ] = $fixed_link;

				return $fixed_link;
			}
		}

		return $post_link;
	}*/

	/**
	 * Set permalink for each tour on category tour type.
	 *
	 * @param string $post_link
	 * @param WP_Post $post
	 *
	 * @return string
	 */
	public static function link_tour( $post_link, $post ): string {
		try {
			if ( 'product' !== $post->post_type ) {
				return $post_link;
			}

			$product = wc_get_product( $post );
			if ( $product->get_type() !== TB_PHYS_PRODUCT_TYPE ) {
				return $post_link;
			}

			$post_link = self::get_tour_base_slug() . $post->post_name;
		} catch ( Throwable $e ) {
			error_log( $e->getMessage() );
		}

		if ( empty( $post_link ) ) {
			$post_link = '';
		}

		return $post_link;
	}

	/**
	 * Rewrite slug attribute of tour.
	 *
	 * @param string[] $rules
	 *
	 * @return array
	 */
	public static function rewrite_rules( $rules ): array {
		$tour_base_url = self::get_tour_base_slug();
		if ( $tour_base_url ) {
			$tour_base_url = ltrim( $tour_base_url, '/' );
			$new_rules     = array(
				$tour_base_url . 'page/([0-9]{1,})/?' => 'index.php?is_tour=1&paged=$matches[1]',
				$tour_base_url . '?$'                 => 'index.php?is_tour=1', // &post_type=product&product_type=tour_phys
				$tour_base_url . '(.+)'               => 'index.php?product=$matches[1]',
			);

			if ( is_plugin_active( 'polylang/polylang.php' ) ) { // phai chuan theo thu tu
				$current_lang = pll_current_language();
				$new_rules[ '(' . $current_lang . ')/' . $tour_base_url . 'page/([0-9]{1,})/?' ] = 'index.php?lang=$matches[1]&is_tour=1&paged=$matches[2]';
				$new_rules[ '(' . $current_lang . ')/' . $tour_base_url . '([^/]+)' ]            = 'index.php?lang=$matches[1]&product=$matches[2]';
			}

			return array_merge( $new_rules, $rules );
		}

		if ( empty( $rules ) ) {
			$rules = [];
		}

		return $rules;
	}

	public static function get_tour_base_slug() {
		static $base_full;

		if ( is_null( $base_full ) ) {
			$tours_page_id = get_option( Tour_Settings_Tab_Phys::$_tours_show_page_id );
			$base_url      = $tours_page_id && $tours_page_id != '' ? get_page_uri( $tours_page_id ) : __( 'tours', 'travel-booking' );
			$base_url      = apply_filters( 'travel_base_url_single_tour', $base_url );

			if ( $base_url ) {
				$base_url .= '/';
			}

			$front = $GLOBALS['wp_rewrite']->front;
			if ( $front != '/index.php/' ) {
				$front = '/';
			}
			$base_full = $base_url ? $front . $base_url : '';
		}

		return $base_full;
	}

	public static function rewrite_slug_attribute_woo_by_phys() {
		$taxonomies    = get_object_taxonomies( 'product', 'objects' );
		$attribute_arr = array();

		if ( empty( $taxonomies ) ) {
			return '';
		}

		foreach ( $taxonomies as $tax ) {
			$tax_name = $tax->name;
			if ( 0 !== strpos( $tax_name, 'pa_' ) ) {
				continue;
			}
			if ( ! in_array( $tax_name, $attribute_arr ) ) {
				$attribute_arr[ $tax_name ] = $tax_name;
			}
		}

		foreach ( $attribute_arr as $k => $attr ) {
			$taxonomy_attr = get_taxonomy( $attr );
			$attr_name     = str_replace( 'pa_', '', $attr );
			$slug_rewrite  = 'tour-' . $attr_name;
			if ( $slug_rewrite == 'tour-destination' ) {
				$slug_rewrite = apply_filters( 'slug-tour-destination', $slug_rewrite );
			} elseif ( $slug_rewrite == 'tour-month' ) {
				$slug_rewrite = apply_filters( 'slug-tour-month', $slug_rewrite );
			} else {
				$slug_rewrite = apply_filters( 'slug-tour-attr', $slug_rewrite );
			}

			$label                    = $attr_name;
			$taxonomy_data            = array(
				'labels'       => array(
					'name'              => $label,
					'singular_name'     => $taxonomy_attr->labels->singular_name,
					'search_items'      => sprintf( __( 'Search %s', 'woocommerce' ), $label ),
					'all_items'         => sprintf( __( 'All %s', 'woocommerce' ), $label ),
					'parent_item'       => sprintf( __( 'Parent %s', 'woocommerce' ), $label ),
					'parent_item_colon' => sprintf( __( 'Parent %s:', 'woocommerce' ), $label ),
					'edit_item'         => sprintf( __( 'Edit %s', 'woocommerce' ), $label ),
					'update_item'       => sprintf( __( 'Update %s', 'woocommerce' ), $label ),
					'add_new_item'      => sprintf( __( 'Add New %s', 'woocommerce' ), $label ),
					'new_item_name'     => sprintf( __( 'New %s', 'woocommerce' ), $label ),
					'not_found'         => sprintf( __( 'No &quot;%s&quot; found', 'woocommerce' ), $label ),
				),
				'show_in_menu' => false,
			);
			$taxonomy_data['rewrite'] = array(
				'slug'         => '/' . $slug_rewrite,
				'with_front'   => false,
				'hierarchical' => true,
			);
			register_taxonomy( $attr, apply_filters( "woocommerce_taxonomy_objects_{$attr}", array( 'product' ) ), apply_filters( "woocommerce_taxonomy_args_{$attr}", $taxonomy_data ) );

			flush_rewrite_rules();
			delete_transient( 'wc_attribute_taxonomies' );
		}
	}

	public static function filter_nav_menu_item_tour_phys( $menu_items ) {
		$isPagesTour = TravelPhysUtility::check_is_tour_archive() || TravelPhysUtility::check_is_tour_single();

		if ( ! $isPagesTour ) {
			return $menu_items;
		}

		if ( ! is_woocommerce() ) {
			return $menu_items;
		}

		$tour_page = get_option( Tour_Settings_Tab_Phys::$_tours_show_page_id );
		$shop_page = (int) wc_get_page_id( 'shop' );

		foreach ( (array) $menu_items as $key => $menu_item ) {

			$classes = (array) $menu_item->classes;

			if ( TravelPhysUtility::check_is_tour_archive() && $tour_page == $menu_item->object_id && 'page' === $menu_item->object ) {
				$menu_items[ $key ]->current = true;
				$classes[]                   = 'current-menu-item';
				$classes[]                   = 'current_page_item';

			} elseif ( is_singular( 'product' ) && ! TravelPhysUtility::check_is_tour_single() ) {
				if ( $shop_page == $menu_item->object_id ) {
					$classes[] = 'current_page_parent';
				} else {
					unset( $classes[ array_search( 'current_page_parent', $classes ) ] );
				}
			} elseif ( TravelPhysUtility::check_is_tour_archive() && is_shop() && $shop_page == $menu_item->object_id && 'page' === $menu_item->object ) {
				$menu_items[ $key ]->current = false;
				unset( $classes[ array_search( 'current-menu-item', $classes ) ] );
				unset( $classes[ array_search( 'current_page_item', $classes ) ] );
			} elseif ( TravelPhysUtility::check_is_tour_single() ) {
				if ( $tour_page == $menu_item->object_id ) {
					$classes[] = 'current_page_parent';
				} else {
					unset( $classes[ array_search( 'current_page_parent', $classes ) ] );
				}
			}

			$menu_items[ $key ]->classes = array_unique( $classes );

		}

		return $menu_items;
	}

	public static function check_is_tour_redirect_product_to_link_tour() {
		$product             = wc_get_product();
		$permalink_structure = get_option( 'permalink_structure' );

		if ( $product && $product->get_type() == 'tour_phys' && $permalink_structure != '' ) {
			$permalink_structure_woo = get_option( 'woocommerce_permalinks' );

			if ( key_exists( 'product_base', $permalink_structure_woo ) ) {
				global $wp;
				$url_current              = home_url( $wp->request );
				$isLinkTourSlugProduct    = str_replace( home_url( '/' ), '', $url_current );
				$isLinkTourSlugProductArr = explode( '/', $isLinkTourSlugProduct );

				$slug_product_base = str_replace( '/', '', $permalink_structure_woo['product_base'] );
				$slug_tour_base    = str_replace( '/', '', self::get_tour_base_slug() );

				if ( $isLinkTourSlugProductArr[0] == $slug_product_base ) {
					wp_redirect( str_replace( $slug_product_base, $slug_tour_base, $url_current ) );
					die();
				}
			}
		}

		// Fix for Plugin Polylang:  archive page tours get tours with default lang
		if ( is_plugin_active( 'polylang/polylang.php' ) ) {
			$default_lang         = pll_default_language( 'slug' );
			$current_lang         = pll_current_language( 'slug' );
			$_tours_show_page_id  = Tour_Settings_Tab_Phys::$_tours_show_page_id;
			$link_page_show_tours = get_page_link( (int) get_option( $_tours_show_page_id ) );

			$actual_link = ( isset( $_SERVER['HTTPS'] ) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http' ) . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";

			if ( $actual_link == $link_page_show_tours && $current_lang == $default_lang ) {
				wp_redirect( $link_page_show_tours . '?lang=en' );
				die();
			}
		}
	}

	public static function change_link_tour_view_actions_phys( $actions, $post ) {

		if ( isset( $_GET['post_type'] ) && $_GET['post_type'] == 'product'
			&& isset( $_GET['product_type'] ) && $_GET['product_type'] == 'tour_phys' ) {

			$permalink_structure = get_option( 'permalink_structure' );

			if ( $permalink_structure != '' ) {
				$permalink_structure_woo = get_option( 'woocommerce_permalinks' );

				if ( key_exists( 'product_base', $permalink_structure_woo ) ) {
					$slug_product_base = str_replace( '/', '', $permalink_structure_woo['product_base'] );
					$slug_tour_base    = str_replace( '/', '', self::get_tour_base_slug() );
					$linkProduct       = str_replace( $slug_product_base, $slug_tour_base, get_permalink( $post->ID ) );

					$actions['view'] = sprintf(
						'<a href="%s" rel="bookmark">%s</a>',
						$linkProduct,
						__( 'View' )
					);
				}
			}
		}

		return $actions;
	}

	/**
	 * Link tour when edit Tour.
	 *
	 * @param $link
	 * @param $post_id
	 * @param $new_title
	 * @param $new_slug
	 * @param $post
	 *
	 * @return array|mixed|string|string[]
	 */
	public static function link_tour_backend( $link, $post_id, $new_title, $new_slug, $post ) {
		$product = wc_get_product( $post_id );
		if ( ! $product || $product->get_type() !== TB_PHYS_PRODUCT_TYPE ) {
			return $link;
		}

		$permalink_structure_woo = get_option( 'woocommerce_permalinks' );
		if ( key_exists( 'product_base', $permalink_structure_woo ) ) {
			$slug_product_base = str_replace( '/', '', $permalink_structure_woo['product_base'] );
			$slug_tour_base    = str_replace( '/', '', self::get_tour_base_slug() );
			$link              = str_replace( $slug_product_base, $slug_tour_base, $link );
		}

		return $link;
	}

	//<editor-fold desc="WPML">
	public static function fix_switcher_menu_for_tour( $html, $model, $slot ) {
		//	echo '<pre>' . print_r( $model, true ) . '</pre>';
		return $html;
	}

	public static function wpml_get_translated_slug_for_tour( $slug, $post_type, $language_code ) {
		return $slug;
	}

	public static function change_link_archive_product_when_is_tour( $link, $post_type ) {
		if ( TravelPhysUtility::check_is_tour_archive() ) {
			$_tours_show_page_id = (int) get_option( Tour_Settings_Tab_Phys::$_tours_show_page_id );

			$link = get_page_link( $_tours_show_page_id );
		}

		return $link;
	}

	public static function translate_object_id_of_page_show_tours( $shop_id ) {
		if ( TravelPhysUtility::check_is_tour_archive() ) {
			$shop_id = (int) get_option( Tour_Settings_Tab_Phys::$_tours_show_page_id );
		}

		return $shop_id;
	}
	//</editor-fold>

	//<editor-fold desc="Polylang">
	public static function filter_post_type_link_phys_polylang( $link, $lang, $post ) {
		return $link;
	}

	public static function tour_url_polylang( $url, $language ) {

		$optional     = 'slug';
		$default_lang = pll_default_language( $optional );
		$switch_lang  = $language->slug;
		$current_lang = pll_current_language( $optional );

		if ( TravelPhysUtility::check_is_tour_archive() ) {
			$_tours_show_page_id = (int) get_option( Tour_Settings_Tab_Phys::$_tours_show_page_id );

			if ( $current_lang == $default_lang ) {
				if ( $current_lang == $switch_lang ) {

					return $url = get_page_link( $_tours_show_page_id );
				} else {
					$_tours_show_page_id_lang_default = get_option( Tour_Settings_Tab_Phys::$_tours_show_page_id . '_' . $switch_lang );

					return $url = get_page_link( $_tours_show_page_id_lang_default );
				}
			} else {
				if ( $current_lang == $switch_lang ) {

					return $url = get_page_link( $_tours_show_page_id );
				} else {
					$_tours_show_page_id_lang_default = get_option( str_replace( '_' . $current_lang, '', Tour_Settings_Tab_Phys::$_tours_show_page_id ) );

					return $url = get_page_link( $_tours_show_page_id_lang_default );
				}
			}
		}

		return $url;
	}
	//</editor-fold>
}

TravelPhysUrl::init();

