<?php
/**
 * Travel Template Loader
 *
 * @author  physocde
 * @version 2.0.0
 */

class TravelPhysTemplateLoader {

	public static function init() {
		remove_filter( 'template_include', array( 'HotelTemplateLoader', 'hotel_template_loader' ), 11 );
		add_filter( 'template_include', array( __CLASS__, 'tb_template_loader_phys' ), 12, 1 );
	}

	public static function tb_template_loader_phys( $template ) {
		$arr_find_match = array(
			'single-tour.php',
			'archive-tour.php',
			'archive-attribute.php',
			'archive-attribute-tour.php',
		);
		$find           = array( 'woocommerce.php' );
		$file           = '';

		if ( is_embed() ) {
			return $template;
		}

		if ( is_single() && get_post_type() == 'product' ) {
			if ( wc_get_product()->get_type() == 'tour_phys' ) {
				$GLOBALS['wp_query']->set( 'is_single_tour', 1 );
				$file = 'single-tour.php';
			} else {
				$file = 'single-product.php';
			}

			$find[] = $file;
			$find[] = WC()->template_path() . $file;

		} elseif ( is_product_taxonomy() ) {

			$term = get_queried_object();

			if ( is_tax( 'product_cat' ) || is_tax( 'product_tag' ) ) {
				$file = 'taxonomy-' . $term->taxonomy . '.php';
			} else {
				if ( $term->taxonomy == 'tour_phys' ) {
					$GLOBALS['wp_query']->set( 'is_tour', 1 );
					$file = 'archive-tour.php';
				} else {
					$pattern         = '/^pa_/i';
					$check_attribute = preg_match( $pattern, $term->taxonomy );
					if ( $check_attribute ) {
						$file = 'archive-attribute.php';
					} else {
						$file = 'archive-product.php';
					}
				}
			}

			$find[] = 'taxonomy-' . $term->taxonomy . '-' . $term->slug . '.php';
			$find[] = WC()->template_path() . 'taxonomy-' . $term->taxonomy . '-' . $term->slug . '.php';
			$find[] = 'taxonomy-' . $term->taxonomy . '.php';
			$find[] = WC()->template_path() . 'taxonomy-' . $term->taxonomy . '.php';
			$find[] = $file;
			$find[] = WC()->template_path() . $file;

		} elseif ( is_post_type_archive( 'product' ) || is_page( wc_get_page_id( 'shop' ) ) ) {
			$file   = 'archive-product.php';
			$find[] = $file;
			$find[] = WC()->template_path() . $file;
		}

		if ( TravelPhysUtility::check_is_tour_archive() ) {
			$file = 'archive-tour.php';
		}

		if ( $file ) {
			// $template = locate_template( array_unique( $find ) );
			if ( in_array( $file, $arr_find_match ) ) {
				$template = tb_get_file_template( $file );
			} elseif ( ! $template || WC_TEMPLATE_DEBUG_MODE ) {
				$template = WC()->plugin_path() . '/templates/' . $file;
			}
		}

		/*** For permalink structure is Plain ***/
		if ( isset( $_GET['page_id'] ) && $_GET['page_id'] == get_option( Tour_Settings_Tab_Phys::$_tours_show_page_id ) ) {
			wp_safe_redirect( home_url( '?is_tour=1' ) );
		}

		//echo 'Travel loader';

		if ( is_plugin_active( 'hotel-booking/hotel-booking-phys.php' ) ) {
			global $wp;
			$current_url          = home_url( add_query_arg( array(), $wp->request ) ) . '/';
			$_page_id_show_hotels = (int) get_option( HotelSetting::$_hotel_show_page_id );
			$link_archive_hotel   = get_page_link( $_page_id_show_hotels );
			$replace              = str_replace( $link_archive_hotel, '', $current_url );

			if ( $replace != $current_url ) {
				$template = HotelTemplateLoader::hotel_template_loader( $template );

				return $template;
			}
		}

		return $template;
	}
}

TravelPhysTemplateLoader::init();
