<?php
/**
 * Class TravelPhysCheckout
 * @version 1.0.1
 * @author  physcode
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class TravelPhysCheckout {

	public static function init() {
		// review-order.php
		add_filter( 'woocommerce_checkout_cart_item_quantity', array( __CLASS__, 'html_review_order_tour' ), 10, 3 );

		/*** Personal Information ***/
		if ( get_option( Tour_Settings_Tab_Phys::$_personal_information_enable ) == 1 ) {
			add_filter( 'woocommerce_checkout_fields', array( __CLASS__, 'personal_information_fields' ), 11, 1 );
			add_action( 'woocommerce_checkout_before_customer_details', array( __CLASS__, 'personal_information' ), 11 );
			add_filter( 'woocommerce_checkout_update_order_meta', array( __CLASS__, 'save_personal_information' ), 11, 2 );
		}

		add_filter( 'woocommerce_checkout_update_order_meta', array( __CLASS__, 'woocommerce_checkout_update_order_meta' ), 11, 2 );
	}

	public static function woocommerce_checkout_update_order_meta( $order_id, $data ) {
		$cart  = WC()->cart->get_cart();
		$order = new WC_Order( $order_id );
		$items = $order->get_items();

		try {
			foreach ( $items as $item ) {
				$tour          = $item->get_data();
				$tour_id       = $tour['product_id'];
				$cart_item_key = WC()->cart->generate_cart_id( $tour_id );

				if ( array_key_exists( $cart_item_key, $cart ) ) {
					$cart_item = $cart[ $cart_item_key ];

					if ( isset( $cart_item['is_tour'] ) ) {
						foreach ( TravelPhysOrder::$_fields_tour_order as $field ) {
							$key_cart_item = preg_replace( '/^\_/', '', $field );

							if ( $field == '_price_adults' ) {
								wc_add_order_item_meta( $item->get_id(), $field, $cart_item['data']->get_price() );
							} elseif ( isset( $cart_item[ $key_cart_item ] ) ) {
								wc_add_order_item_meta( $item->get_id(), $field, $cart_item[ $key_cart_item ] );
							}
						}
					}
				}
			}
		} catch ( Exception $e ) {

		}
	}

	public static function html_review_order_tour( $html_item_name, $cart_item, $cart_item_key ) {
		if ( isset( $cart_item['is_tour'] ) ) {

			$html_item_name = '';

			if ( isset( $cart_item['date_booking'] ) && isset( $cart_item['tour_date_end'] ) ) {
				$date_check_in  = $cart_item['date_booking'];
				$date_check_out = $cart_item['tour_date_end'];

				$html_item_name .= apply_filters( 'html_check_in_cart', '<div class="cart-item-date-check-in"><strong>' . __( 'Check in', 'travel-booking' ) . '</strong>: ' . $date_check_in . '</div>', $date_check_in );
				$html_item_name .= apply_filters( 'html_check_out_cart', '<div class="cart-item-date-check-out"><strong>' . __( 'Check out', 'travel-booking' ) . '</strong>: ' . $date_check_out . '</div>', $date_check_out );
			}

			if ( isset( $cart_item['date_check_in'] ) && isset( $cart_item['date_check_out'] ) ) {
				$date_check_in  = $cart_item['date_check_in'];
				$date_check_out = $cart_item['date_check_out'];

				$html_item_name .= apply_filters( 'html_check_in_cart', '<div class="cart-item-date-check-in"><strong>' . __( 'Check in', 'travel-booking' ) . '</strong>: ' . $date_check_in . '</div>', $date_check_in );
				$html_item_name .= apply_filters( 'html_check_out_cart', '<div class="cart-item-date-check-out"><strong>' . __( 'Check out', 'travel-booking' ) . '</strong>: ' . $date_check_out . '</div>', $date_check_out );
			}

			if ( isset( $cart_item['number_children'] ) ) {
				$html_item_name .= '<div class="cart-item-number-adult"><strong>' . __( 'Adults', 'travel-booking' ) . '</strong>&nbsp;<span>(' . $cart_item['data']->get_price_html() . ')</span> &times; <span>' . $cart_item['quantity'] . '</span></div>';
				$html_item_name .= '<div class="cart-item-number-child"><strong>' . __( 'Children', 'travel-booking' ) . '</strong>&nbsp;<span>(' . TravelPhysUtility::tour_format_price( $cart_item['price_children'] ) . ')</span> &times; <span>' . $cart_item['number_children'] . '</span></div>';
			} else {
				$html_item_name .= '<div class="cart-item-number-ticket"><strong>' . __( 'Tickets', 'travel-booking' ) . '</strong>&nbsp;<span>(' . $cart_item['data']->get_price_html() . ')</span> &times; <span>' . $cart_item['quantity'] . '</span></div>';
			}

			/*** Variation ***/
			if ( isset( $cart_item['tour_variations'] ) ) {
				$tour_variations         = $cart_item['tour_variations'];
				$tour_variations_options = $cart_item['tour_variations_options'];
				$price_dates_tour        = $cart_item['price_dates_tour'];

				$html_item_name .= TravelPhysVariation::view_variation_detail( $tour_variations, $tour_variations_options, $price_dates_tour );
			}

			/*** Group discount ***/
			if ( isset( $cart_item['tour_group_discount'] ) ) {
				$html_item_name .= apply_filters( 'html_tour_group_discount', $cart_item['tour_group_discount'] );
			}

			do_action( 'html_checkout_review_order_tour_phys', $html_item_name, $cart_item, $cart_item_key );
		}

		return $html_item_name;
	}

	public static function personal_information() {
		tb_get_file_template( 'checkout/personal-information.php' );
	}

	public static function personal_information_fields( $fields ) {
		$travel_personal_information_option = get_option( Tour_Settings_Tab_Phys::$_personal_information );

		if ( $travel_personal_information_option !== '' ) {
			$travel_personal_information_option_obj = json_decode( $travel_personal_information_option );

			if ( ! is_null( $travel_personal_information_option_obj ) && count( (array) $travel_personal_information_option_obj ) > 0 ) {
				$cart = WC()->cart->get_cart();

				//var_dump( $travel_personal_information_option_obj );

				$fields['personal_information'] = array();

				foreach ( $cart as $cart_item ) {
					$tour      = $cart_item['data'];
					$qty_adult = (int) $cart_item['quantity'];
					$key       = $tour->get_id() . '_';

					if ( array_key_exists( 'is_tour', $cart_item ) ) {
						for ( $i = 1; $i <= $qty_adult; $i ++ ) {
							foreach ( $travel_personal_information_option_obj as $k_field => $v_field ) {
								if ( $v_field->enable ) {
									$key_field                                    = $key . $k_field . '_adult_' . $i;
									$fields['personal_information'][ $key_field ] = array(
										'type'     => $v_field->type,
										'label'    => __( $v_field->label, 'travel-booking' ),
										'required' => $v_field->required,
									);
								}
							}
						}

						if ( array_key_exists( 'number_children', $cart_item ) ) {
							$qty_children = (int) $cart_item['number_children'];

							for ( $i = 1; $i <= $qty_children; $i ++ ) {
								foreach ( $travel_personal_information_option_obj as $k_field => $v_field ) {
									if ( $v_field->enable ) {
										$key_field                                    = $key . $k_field . '_child_' . $i;
										$fields['personal_information'][ $key_field ] = array(
											'type'     => $v_field->type,
											'label'    => __( $v_field->label, 'travel-booking' ),
											'required' => $v_field->required,
										);
									}
								}
							}
						}
					}
				}
			}
		}

		//var_dump( $fields );

		return $fields;
	}

	public static function save_personal_information( $order_id ) {
		$cart = WC()->cart->get_cart();

		$travel_personal_information_option = get_option( Tour_Settings_Tab_Phys::$_personal_information );

		if ( $travel_personal_information_option !== '' ) {
			$travel_personal_information_option_obj = json_decode( $travel_personal_information_option );

			foreach ( $cart as $cart_item ) {
				$tour      = $cart_item['data'];
				$qty_adult = (int) $cart_item['quantity'];
				$key       = $tour->get_id() . '_';

				if ( array_key_exists( 'is_tour', $cart_item ) ) {
					for ( $i = 1; $i <= $qty_adult; $i ++ ) {
						foreach ( $travel_personal_information_option_obj as $k_field => $v_field ) {
							if ( $v_field->enable ) {
								$key_field = $key . $k_field . '_adult_' . $i;

								if ( ! empty( $_POST[ $key_field ] ) ) {
									$value = $_POST[ $key_field ];
									if ( is_array( $value ) ) {
										$value = implode( ',', $value );
									}
									update_post_meta( $order_id, $key_field, sanitize_text_field( $value ) );
								}
							}
						}
					}

					if ( array_key_exists( 'number_children', $cart_item ) ) {
						$qty_children = (int) $cart_item['number_children'];

						for ( $i = 1; $i <= $qty_children; $i ++ ) {
							foreach ( $travel_personal_information_option_obj as $k_field => $v_field ) {
								if ( $v_field->enable ) {
									$key_field = $key . $k_field . '_child_' . $i;

									if ( ! empty( $_POST[ $key_field ] ) ) {
										$value = $_POST[ $key_field ];
										if ( is_array( $value ) ) {
											$value = implode( ',', $value );
										}
										update_post_meta( $order_id, $key_field, sanitize_text_field( $value ) );
									}
								}
							}
						}
					}
				}
			}

			update_post_meta( $order_id, 'travel_personal_information_option', sanitize_text_field( $_POST['travel_personal_information_option'] ) );
		}
	}
}

TravelPhysCheckout::init();
